------------------------------------------------------------------------------------------------------
-- TotemusTimers
--
-- Maintainer: Poolpy
--
-- Based on Ideas by:
--   TotemsTimers by Zulah.
------------------------------------------------------------------------------------------------------

--TTPlayerSpells = { };

TTIsAncientManaSpring = false;
TTLastSearingRank = 1;
TTLastStoneClawRank = 1;

-- functions

local Dragging = 0;

function TotemusTimers_OnUpdate(arg1)
	if( this.element ) then
		local data = TTActiveTotems[this.element];
		if ( data and data.active ) then
                        if ( data.amel )then
                           local amel, buffed = data.amel, 0;
                           if TotemusTimers_BuffInfo("player", amel) then
                               buffed = 1;
                           else
                               buffed = 0;
                           end
                           for i=1,4 do
                               if TotemusTimers_BuffInfo("party"..i, amel) then
                                  buffed = buffed+1;
                               end
                           end
                                getglobal(this:GetName().."Unit"):SetText(buffed);
                                getglobal(this:GetName().."Unit"):SetTextColor(1.0,1.0,1.0);
                        else
                                getglobal(this:GetName().."Unit"):SetText("");
                        end
			if ( data.duration < 0 ) then
				TotemusTimers_TotemDeath(data.totem);
			else
				data.duration = data.duration - arg1;
				getglobal(this:GetName().."Time"):SetText(TotemusTimers_FormatTime(data.duration));
				if( TTData.Totems[data.totem] ) then
					if( data.warningTime ) then
						if ( data.duration <= data.warningTime ) then
							data.warningTime = nil;
							TotemusTimers_TotemWarn(data.totem);
						end
					end
				end
				if( data.duration <= 60 ) then
					getglobal(this:GetName().."Time"):SetTextColor(1.0,1.0,1.0);
				else
					getglobal(this:GetName().."Time"):SetTextColor(1.0,.8,0);
				end
				if( data.duration <= TTData.flash ) then
					data.flashTime = data.flashTime - arg1;
					if ( data.flashTime < 0 ) then
						if ( data.flashState == 1 ) then
							data.flashState = 0;
							data.flashTime = BUFF_FLASH_TIME_OFF;
						else
							data.flashState = 1;
							data.flashTime = BUFF_FLASH_TIME_ON;
						end
					end
					if ( data.flashState == 1 ) then
						totemAlphaValue = (BUFF_FLASH_TIME_ON - data.flashTime) / BUFF_FLASH_TIME_ON;
						totemAlphaValue = totemAlphaValue * (1 - BUFF_MIN_ALPHA) + BUFF_MIN_ALPHA
					else
						totemAlphaValue = data.flashTime / BUFF_FLASH_TIME_ON;
						totemAlphaValue = (data.flashTime * (1 - BUFF_MIN_ALPHA)) + BUFF_MIN_ALPHA;
						getglobal(this:GetName().."Icon"):SetAlpha(data.flashTime / BUFF_FLASH_TIME_ON);
					end
					getglobal(this:GetName().."Icon"):SetAlpha(totemAlphaValue);
				end
			end
		end
	end
end

--[[function TotemusTimers_ReCast() - This function is toast as of 2.01
	if( TTData.lock == 1 ) then
		local data = TTActiveTotems[this.element];
		--DEFAULT_CHAT_FRAME:AddMessage(TTActiveTotems[this.element]);
		--DEFAULT_CHAT_FRAME:AddMessage(data);
		if( data ) then
			if( data["action"] ) then
				UseAction(data["action"], data["number"], data["target"]);
			elseif( data["spell"] ) then
				CastSpell(data["spell"], data["book"]);
			elseif ( data["Slot_Id"] ) then
				--DEFAULT_CHAT_FRAME:AddMessage(data["Slot_Id"])
				UseInventoryItem( data["Slot_Id"] );
			end
		end
	end
end]]

function TotemusTimers_BuffInfo(unit, amel)
local nba,nna = 1,"";
  while nna do
    nna = UnitBuff(unit, nba);
    if nna==amel then return UnitBuff(unit, nba);
    else nba = nba+1; end
  end
  return nil;
end


function TotemusTimers_OnShow()
	if( Totemus.db.char.timersShow == true ) then
		TotemusTimersFrame:Show();
                  else
		TotemusTimersFrame:Hide();
	end
end

function TotemusTimers_OnDragStart()
	if( Totemus.db.char.timersLock ~= true ) then
		TotemusTimersFrame:StartMoving();
	end
end

function TotemusTimers_OnDragStop()
	TotemusTimersFrame:StopMovingOrSizing();
end

function TotemusTimers_OnEnter()
	local data = TTActiveTotems[this.element];
	if( data ) then
		if ( this:GetCenter() < UIParent:GetCenter() ) then
			GameTooltip:SetOwner(this, "ANCHOR_RIGHT");
		else
			GameTooltip:SetOwner(this, "ANCHOR_LEFT");
		end
		if( data["action"] ) then
			GameTooltip:SetAction(data["action"]);
		elseif( data["spell"] ) then
			GameTooltip:SetSpell(data["spell"], data["book"]);
		elseif( data["Slot_Id"] ) then
			GameTooltip:SetInventoryItem("player", data["Slot_Id"]);
		end
	end
end

function TotemusTimers_OnLoad()
	this:RegisterForClicks("LeftButtonUp","RightButtonUp");
end

-- Functions ripped from TotemusTimers
function TotemusTimers_FormatTime(seconds)
  local d, h, m, s;
  local text;

 	if( Totemus.db.char.timersTime == true ) then
		if(seconds <= 0) then
			text = "";
		elseif(seconds < 60) then
			d, h, m, s = ChatFrame_TimeBreakDown(seconds);
			text = format("%d s", s);
		elseif(seconds < 3600) then
			d, h, m, s = ChatFrame_TimeBreakDown(seconds);
			text = format("%d m", m);
		else
			text = "1 hr+";
		end
	else
		if(seconds <= 0) then
			text = "";
		elseif(seconds < 3600) then
			d, h, m, s = ChatFrame_TimeBreakDown(seconds);
			text = format("%02d:%02d", m, s);
		else
			text = "1 hr+";
		end
	end

  return text;
end

function TotemusTimers_PrintUsage(usage)
	if(usage) then
		DEFAULT_CHAT_FRAME:AddMessage(TT_USAGE.." "..usage);
	end

end

function TotemusTimers_ValidElement(element)
	if(element) then
		if( element == TT_EARTH or
			element == TT_FIRE or
			element == TT_AIR or
			element == TT_WATER ) then
			return 1;
		end

	end
	return nil;
end

function TotemusTimers_SetOrientation()
	if( Totemus.db.char.timersArrange == 2 ) then
		TotemusTimers2:ClearAllPoints();
		TotemusTimers2:SetPoint("Top","TotemusTimers1","Bottom",0,-15);
		TotemusTimers3:ClearAllPoints();
		TotemusTimers3:SetPoint("Top","TotemusTimers2","Bottom",0,-15);
		TotemusTimers4:ClearAllPoints();
		TotemusTimers4:SetPoint("Top","TotemusTimers3","Bottom",0,-15);
	elseif( Totemus.db.char.timersArrange == 3 ) then
		TotemusTimers2:ClearAllPoints();
		TotemusTimers2:SetPoint("Right","TotemusTimers1","Left",-7,0);
		TotemusTimers3:ClearAllPoints();
		TotemusTimers3:SetPoint("Top","TotemusTimers1","Bottom",0,-15);
		TotemusTimers4:ClearAllPoints();
		TotemusTimers4:SetPoint("Right","TotemusTimers3","Left",-7,0);
	else
		TotemusTimers2:ClearAllPoints();
		TotemusTimers2:SetPoint("Right","TotemusTimers1","Left",-7,0);
		TotemusTimers3:ClearAllPoints();
		TotemusTimers3:SetPoint("Right","TotemusTimers2","Left",-7,0);
		TotemusTimers4:ClearAllPoints();
		TotemusTimers4:SetPoint("Right","TotemusTimers3","Left",-7,0);
	end
		
end

function TotemusTimers_Disable() 
	TotemusTimers_IsEnabled = false
	TotemusTimersFrame:UnregisterEvent("VARIABLES_LOADED");

	TotemusTimersFrame:UnregisterEvent("CHAT_MSG_SPELL_SELF_BUFF");
	TotemusTimersFrame:UnregisterEvent("PLAYER_LEVEL_UP");
	TotemusTimersFrame:UnregisterEvent("PLAYER_ENTERING_WORLD");

	TotemusTimersFrame:UnregisterEvent("SPELLCAST_STOP");
  TotemusTimersFrame:RegisterEvent("PLAYER_DEAD");
	TotemusTimersFrame:UnregisterEvent("CHAT_MSG_COMBAT_FRIENDLY_DEATH");
	TotemusTimersFrame:UnregisterEvent("CHAT_MSG_COMBAT_CREATURE_VS_SELF_HITS");
	TotemusTimersFrame:UnregisterEvent("CHAT_MSG_COMBAT_HOSTILEPLAYER_HITS");
	TotemusTimersFrame:UnregisterEvent("CHAT_MSG_SPELL_CREATURE_VS_SELF_DAMAGE");
	TotemusTimersFrame:UnregisterEvent("CHAT_MSG_SPELL_HOSTILEPLAYER_DAMAGE");

end

function TotemusTimers_Enable() 
	TotemusTimers_IsEnabled = true
	TotemusTimersFrame:RegisterEvent("VARIABLES_LOADED");

	TotemusTimersFrame:RegisterEvent("CHAT_MSG_SPELL_SELF_BUFF");
	TotemusTimersFrame:RegisterEvent("PLAYER_LEVEL_UP");
	TotemusTimersFrame:RegisterEvent("PLAYER_ENTERING_WORLD");

	TotemusTimersFrame:RegisterEvent("SPELLCAST_STOP");
	TotemusTimersFrame:RegisterEvent("PLAYER_DEAD");
	TotemusTimersFrame:RegisterEvent("UNIT_SPELLCAST_SUCCEEDED");
	TotemusTimersFrame:RegisterEvent("CHAT_MSG_COMBAT_FRIENDLY_DEATH");
	TotemusTimersFrame:RegisterEvent("CHAT_MSG_COMBAT_CREATURE_VS_SELF_HITS");
	TotemusTimersFrame:RegisterEvent("CHAT_MSG_COMBAT_HOSTILEPLAYER_HITS");
	TotemusTimersFrame:RegisterEvent("CHAT_MSG_SPELL_CREATURE_VS_SELF_DAMAGE");
	TotemusTimersFrame:RegisterEvent("CHAT_MSG_SPELL_HOSTILEPLAYER_DAMAGE");
	this:RegisterEvent("CHAT_MSG_SPELL_PERIODIC_SELF_BUFFS");
	this:RegisterEvent("CHAT_MSG_SPELL_AURA_GONE_SELF");
	this:RegisterEvent("CHAT_MSG_SPELL_SELF_DAMAGE");
end
	
function TotemusTimers_OnLoad()
	TotemusTimers_Enable();
	TotemusTimers_SetupHooks();
	this:RegisterForDrag("LeftButton");
end

function TotemusTimers_DestroyTotem(totem)
	TTActiveTotems[totem].active = nil;
	--local element = TTActiveTotems[totem].element;
	--TTActiveTotems[element] = nil;
	--TTActiveTotems[totem] = nil;
	TotemusTimers_UpdateButtons();
end

function TotemusTimers_ProcessAlias(text)
	if (TT_ALIAS) then
		for num, data in pairs(TT_ALIAS) do
			text = string.gsub(text, data.alias, data.string);
		end
	end
	return text;
end

function TotemusTimers_CastSpell(id, book)
	local spell, rank = GetSpellName(id, BOOKTYPE_SPELL)
	_,_,rank = string.find(rank, "(%d)")
	if string.find(spell, TT_MANA_SPRING) then
		TTIsAncientManaSpring = false
	elseif string.find(spell, TT_SEARING) then
		TTLastSearingRank = tonumber(rank)
	elseif string.find(spell, TT_STONECLAW) then
		TTLastStoneClawRank = tonumber(rank)
	end
end

function TotemusTimers_UseAction(slot, number, target)
	local itemtype, id, subtype = GetActionInfo(slot);
	if itemtype == "item" and id == 20503 then  -- Ancient Mana Spring
		local _, duration, _ = GetActionCooldown(slot)
		if duration ~= 180 then TTIsAncientManaSpring = true end		
	elseif itemtype == "spell" then
		local spell, rank = GetSpellName(id, BOOKTYPE_SPELL)
		_,_,rank = string.find(rank, "(%d)")
		if string.find(spell, TT_MANA_SPRING) then
			TTIsAncientManaSpring = false
		elseif string.find(spell, TT_SEARING) then
			TTLastSearingRank = tonumber(rank)
		elseif string.find(spell, TT_STONECLAW) then
			TTLastStoneClawRank = tonumber(rank)
		end
	end
end

function TotemusTimers_GetMaxSpellRank(spellname)
    local i,name, maxrank, done = 1, nil, 0, false
	while not done do
        name,rank = GetSpellName(i,BOOKTYPE_SPELL)
        if not name then
            done=true
        elseif name == spellname and rank then
			_,_,rank = string.find(rank, "(%d)")
			if tonumber(rank) > maxrank then
				maxrank = tonumber(rank)
			end
        end
        i = i+1
    end
    return maxrank
end


--Additions for hooking CastSpellByName
function TotemusTimers_CastSpellByName(Spell_Name)
	if string.find(Spell_Name, TT_MANA_SPRING) then -- Mana Spring
		TTIsAncientManaSpring = false
	elseif string.find(Spell_Name, TT_SEARING) then -- Searing Totem
		local _,_,rank = string.find(Spell_Name, "(%d)");
		if rank then
			TTLastSearingRank = tonumber(rank);
		else
			TTLastSearingRank = TotemusTimers_GetMaxSpellRank(Spell_Name);
		end
	elseif string.find(Spell_Name, TT_STONECLAW) then -- Searing Totem
		local _,_,rank = string.find(Spell_Name, "(%d)");
		if rank then
			TTLastStoneClawRank = tonumber(rank);
		else
			TTLastStoneClawRank = TotemusTimers_GetMaxSpellRank(Spell_Name);
		end
	end
end

--Additions for hooking UseInventoryItem 
function TotemusTimers_UseInventoryItem(Slot_ID)
	if Slot_ID==13 or Slot_ID==14 then
		local _,_,itemid = string.find(GetInventoryItemLink("player", Slot_ID),"Hitem:(%d+):");
		if itemid == "20503" then
			TTIsAncientManaSpring = true
		end
	end
end

function TotemusTimers_CreateTotem(setTotem)
	--DEFAULT_CHAT_FRAME:AddMessage("We've made it this far")
	local totem = setTotem
	if totem == TT_MANA_SPRING and TTIsAncientManaSpring then
		totem = TT_ANCIENT_MANA_SPRING
		TTIsAncientManaSpring = false
	end
	local at;
	if( TotemData[totem]) then
		at = {};
		if  totem ~= TT_SEARING and totem ~= TT_STONECLAW then
			--DEFAULT_CHAT_FRAME:AddMessage("Default");
			at.duration = TotemData[totem].duration;
			at.hits = TotemData[totem].hits;
		elseif totem == TT_SEARING then
			at.duration = TotemData[totem][TTLastSearingRank].duration;
			at.hits = TotemData[totem].hits;
		elseif totem == TT_STONECLAW then 
			at.duration = TotemData[totem].duration;
			at.hits = TotemData[totem][TTLastStoneClawRank].hits;
		end
		at.damage = 0;
		at.element = TotemData[totem].element;
		at.buff = TotemData[totem].buff;
                if ( TotemData[totem].amel ) then
		       at.amel = TotemData[totem].amel;
		       TTActiveTotems[at.amel] = at;
                end
		
		--Duration/Health Adjustment Code for Totems due to talents--
		if totem == TT_FIRE_NOVA then
			local _, _, _, _, currRank, _ = GetTalentInfo(1,9);
			if ( currRank == 1 ) then
				at.duration = at.duration - 1 ;
			elseif ( currRank == 2 ) then
				at.duration = at.duration - 2 ;
			end
		elseif totem == TT_STONECLAW then
			local _, _, _, _, currRank, _ = GetTalentInfo(1,3);
			at.hits = at.hits + (at.hits * .25 * currRank);
		end
		
		at.totem = totem;
		at.flashTime = BUFF_FLASH_TIME_OFF;
		at.flashState = 0;
		at.active = 1;

		--Create the expiration data, defaults and such.
		if( TTData.Totems[totem] ) then
			if( TTData.Totems[totem].warningTime ) then
				at.warningTime = TTData.Totems[totem].warningTime;
			elseif( TTData.Default.warningTime ) then
				at.warningTime = TTData.Default.warningTime;
			end
		end

		TTActiveTotems[at.element] = at;
		TTActiveTotems[totem] = at;
		TTActiveTotems[at.buff] = at;
		TotemusTimers_UpdateButtons();
	end
end


function TotemusTimers_SetupHooks()
	hooksecurefunc("CastSpellByName", TotemusTimers_CastSpellByName);
	hooksecurefunc("CastSpell", TotemusTimers_CastSpell);
	hooksecurefunc("UseAction", TotemusTimers_UseAction);
	hooksecurefunc("UseInventoryItem", TotemusTimers_UseInventoryItem);
end

function TotemusTimers_OnEvent(event)
	--DEFAULT_CHAT_FRAME:AddMessage("Got Event:"..event);
	if ( event == "VARIABLES_LOADED" ) then
		TotemusTimers_SetupVariables();
	elseif event == "PLAYER_ENTERING_WORLD" or event == "PLAYER_DEAD" or (event == "CHAT_MSG_SPELL_SELF_BUFF" and string.find(arg1, TT_TOTEMIC_CALL)) then
		TotemusTimers_SetupGlobals();
		if TotemusTimers_IsEnabled then
			for num, totem in pairs(TTActiveTotems) do
				totem.active = nil;
			end
			TotemusTimers_UpdateButtons();
		end
	elseif ( event == "CHAT_MSG_SPELL_SELF_BUFF" ) then
		--DEFAULT_CHAT_FRAME:AddMessage(arg1);
		local _,_,totem = string.find(arg1, TT_CAST_REGEX1);
		if not totem then _,_,totem = string.find(arg1, TT_CAST_REGEX2); end
		if totem then
			--DEFAULT_CHAT_FRAME:AddMessage(totem);
			TotemusTimers_CreateTotem(totem);
		end
		TTState = 0;
		
	elseif ( event == "CHAT_MSG_SPELL_CREATURE_VS_SELF_DAMAGE" or 
			 event == "CHAT_MSG_COMBAT_CREATURE_VS_SELF_HITS" or
			 event == "CHAT_MSG_SPELL_HOSTILEPLAYER_DAMAGE" or
			 event == "CHAT_MSG_COMBAT_HOSTILEPLAYER_HITS" ) then
		local match = { };
		for num, regex in pairs(TT_DAMAGE_REGEX) do
			if string.find(arg1, regex) then
                                _,_,totem, rank, reste = string.find(arg1, regex);
                                if totem == "de R\195\169sistance \195\160 la Nature" then 
                                   totem = "de r\195\169sistance \195\160 la Nature"
                                end
                                if rank ~= "I" and rank ~= "II" and rank ~= "III" and rank ~= "IV" and rank ~= "V" and rank ~= "VI" and rank ~= "VII" and rank ~= "VIII" then 
                                totem = strconcat(totem, " ", rank)
                                end
                                degats = TotemusTimers_premierEntierChaine(arg1);
				TotemusTimers_TotemDamage(totem, degats);
				break;
			end
		end
	end
end

function TotemusTimers_premierEntierChaine(arg2) -- Thanks to chaman2 for that
  local resultat = 0;
  local entierTrouve = false;
  if arg2==nil then
    return 0;
  end
  while not entierTrouve do
    local d,f = string.find(arg2, "(%d+)");
    if not d then 
      entierTrouve = true;
      resultat = 0;
    else
      local csuiv = string.sub(arg2, f+1,f+1);
      if csuiv=="" or csuiv==" " or csuiv=="." or csuiv=="," then 
        entierTrouve = true;
        if csuiv=="" then
          resultat = tonumber(string.sub(arg2, d));
        else
          resultat = tonumber(string.sub(arg2, d,f));
        end
      else
        arg2 = string.sub(arg2, f+1);
      end
    end
  end
  return resultat;
end

function TotemusTimers_UpdateButtons()

	local i,inc,j;
	if( Totemus.db.char.timersAlign == 1 ) then
		i = 4;
		inc = -1;
	else
		i = 1;
		inc = 1;
	end
	for j = 1, 4 do
		getglobal("TotemusTimers"..j):SetAlpha(1.0);
		getglobal("TotemusTimers"..j.."Icon"):SetTexture("");
		getglobal("TotemusTimers"..j.."Time"):SetText("");
		getglobal("TotemusTimers"..j.."Unit"):SetText("");
		getglobal("TotemusTimers"..j).element = nil;
	end
	for num, element in pairs(TTData[TT_ORDER]) do
		-- DEFAULT_CHAT_FRAME:AddMessage("Processing:"..element);
		if( TTActiveTotems[element] ) then
			data = TTActiveTotems[element];
			if( TTActiveTotems[element].active ) then
				getglobal("TotemusTimers"..i.."Icon"):SetTexture("Interface\\Icons\\"..TotemData[data.totem].icon);
				getglobal("TotemusTimers"..i).element = element;
				getglobal("TotemusTimers"..i.."Icon"):SetAlpha(1.0);
				getglobal("TotemusTimers"..i.."Time"):SetText(TotemusTimers_FormatTime(data.duration));
				i = i + inc;
			elseif ( Totemus.db.char.timersStyle == 1 ) then
				getglobal("TotemusTimers"..i.."Icon"):SetTexture("Interface\\Icons\\"..TotemData[data.totem].icon);
				getglobal("TotemusTimers"..i).element = element;
				getglobal("TotemusTimers"..i.."Icon"):SetAlpha(0.4);
				getglobal("TotemusTimers"..i.."Time"):SetText("");
		                getglobal("TotemusTimers"..i.."Unit"):SetText("");
				i = i + inc;
			elseif ( Totemus.db.char.timersStyle == 2 ) then
				getglobal("TotemusTimers"..i.."Icon"):SetTexture("Interface\\Icons\\"..TT_EMPTY_ICON);
				getglobal("TotemusTimers"..i.."Time"):SetText(element);
		                getglobal("TotemusTimers"..i.."Unit"):SetText("");
				getglobal("TotemusTimers"..i.."Icon"):SetAlpha(1.0);
				getglobal("TotemusTimers"..i.."Time"):SetTextColor(1.0,.8,0);
				i = i + inc;
			elseif ( Totemus.db.char.timersStyle == 3 ) then
				i = i + inc;
			end
			TotemData[data.totem].button = getglobal("TotemusTimers"..i);
		else
			if ( Totemus.db.char.timersStyle == 3 ) then
				i = i + inc;
			elseif ( Totemus.db.char.timersStyle == 1 ) then
				--[[  I don't like this.  changed my minde ;)
				getglobal("TotemusTimers"..i.."Icon"):SetTexture("Interface\\Icons\\"..TT_EMPTY_ICON);
				getglobal("TotemusTimers"..i.."Time"):SetText(element);
	                	getglobal("TotemusTimers"..i.."Unit"):SetText("");
				getglobal("TotemusTimers"..i):SetAlpha(0.4);
				getglobal("TotemusTimers"..i.."Time"):SetTextColor(1.0,.8,0);
			]]
				i = i + inc;
			elseif ( Totemus.db.char.timersStyle == 4 ) then
				getglobal("TotemusTimers"..i.."Icon"):SetTexture("Interface\\Icons\\"..TT_EMPTY_ICON);
				getglobal("TotemusTimers"..i.."Time"):SetText(element);
		                getglobal("TotemusTimers"..i.."Unit"):SetText("");
				getglobal("TotemusTimers"..i.."Icon"):SetAlpha(1.0);
				getglobal("TotemusTimers"..i.."Time"):SetTextColor(1.0,.8,0);
				getglobal("TotemusTimers"..i.."Buff"):SetTextColor(2.0,.6,0);
				i = i + inc;
			end
		end
	end
end
    
function TotemusTimers_TotemWarn(totem)
	if( TTData.Totems[totem] ) then
		local rank = TTActiveTotems[totem].rank;
		if( rank and rank > 0 ) then
			TotemusTimers_NotifyWarning(format(TT_NAME_LEVEL_STRING, totem, rank), TTData.Totems[totem]);
		else
			TotemusTimers_NotifyWarning(format(TT_NAME_STRING, totem ), TTData.Totems[totem]);
		end
	end
end

function TotemusTimers_TotemDeath(totem)
	if( TTData.Totems[totem] ) then
		local rank = TTActiveTotems[totem].rank;
		if( rank and rank > 0 ) then
			TotemusTimers_NotifyDestroy(format(TT_NAME_LEVEL_STRING, totem, rank), TTData.Totems[totem]);
		else
			TotemusTimers_NotifyDestroy(format(TT_NAME_STRING, totem ), TTData.Totems[totem]);
		end
	end
	TotemusTimers_DestroyTotem(totem);

end

function TotemusTimers_TotemDamage(totem, damage)

	if ( TTActiveTotems[totem] ) then
		TTActiveTotems[totem].damage = TTActiveTotems[totem].damage + damage;
		--DEFAULT_CHAT_FRAME:AddMessage("[TT] Damage: "..TTActiveTotems[totem].damage);
		--DEFAULT_CHAT_FRAME:AddMessage("[TT] Hits: "..TTActiveTotems[totem].hits);
		if ( TTActiveTotems[totem].damage >= TTActiveTotems[totem].hits ) then
			TotemusTimers_TotemDeath(totem);
		end
	end


end

function TotemusTimers_NotifyWarning(name,item)
	if( Totemus.db.char.timersWarn == true ) then

		local warningMsg, warningColor;

		if ( item.warningMsg ) then
			warningMsg = item.warningMsg;
		else 
			if( TTData.Default.warningMsg ) then
				warningMsg = TTData.Default.warningMsg;
			else
				warningMsg = TT_WARNING;
			end
		end

		if ( item.warningColor ) then
			warningColor = item.warningColor;
		else
			if( TTData.Default.warningColor ) then
				warningColor = TTData.Default.warningColor;
			else
				warningColor =  { 1.0, 1.0, 1.0 } ;
			end
		end
		UIErrorsFrame:AddMessage(name.." "..warningMsg,  
			warningColor[1], 
			warningColor[2], 
			warningColor[3], 
			1.0, UIERRORS_HOLD_TIME);	

		if ( item.warningSound ) then
			PlaySoundFile(item.warningSound);
		elseif( TTData.Default.warningSound ) then
			PlaySoundFile(TTData.Default.warningSound);
		end
	end
		
end

function TotemusTimers_NotifyDestroy(name,item)
	if( Totemus.db.char.timersNotify == true ) then
		local expireColor;

		if ( item.expireMsg ) then
			if ( item.expireColor ) then
				expireColor = item.expireColor;
			else
				if( TTData.Default.expireColor ) then
					expireColor = TTData.Default.expireColor;
				else
					expireColor =  { 1.0, 1.0, 1.0 } ;
				end
			end
			UIErrorsFrame:AddMessage(name.." "..item.expireMsg,  
				expireColor[1], 
				expireColor[2], 
				expireColor[3], 
				1.0, UIERRORS_HOLD_TIME);	
		elseif ( TTData.Default.expireMsg ) then
			if ( item.expireColor ) then
				expireColor = item.expireColor;
			else
				if( TTData.Default.expireColor ) then
					expireColor = TTData.Default.expireColor;
				else
					expireColor =  { 1.0, 1.0, 1.0 } ;
				end
			end
			UIErrorsFrame:AddMessage(name.." "..TTData.Default.expireMsg,  
				expireColor[1], 
				expireColor[2], 
				expireColor[3], 
				1.0, UIERRORS_HOLD_TIME);	
		end

		if ( item.expireSound ) then
			PlaySoundFile(item.expireSound);
		elseif ( TTData.Default.expireSound ) then
			PlaySoundFile(TTData.Default.expireSound);
		end
	end
		
end

function TotemusTimers_SetupVariables()

	if( UnitClass("player") == TT_SHAMAN ) then
		if( not TTActiveTotems ) then
			TTActiveTotems = { };
		end

		if( not TTData ) then
			TTData = { };
			TTData.show = 1;
			TTData.lock = 0;
			TTData.flash = 10;
			TTData[TT_ALIGN] = TT_LEFT;
			TTData[TT_TIME] = TT_CT;
			TTData[TT_NOTIFY] = TT_ON;
			TTData[TT_WARN] = TT_ON;
			TTData[TT_ARRANGE] = TT_HORIZONTAL;
			TTData[TT_STYLE] = TT_STICKY;
			TTData.dragging = 0;
		end

		if( not TTData[TT_ORDER] ) then
			TTData[TT_ORDER] = { TT_AIR, TT_WATER, TT_FIRE, TT_EARTH };
		end

		if( not TTData.Default ) then
			TTData.Default = { };
			TTData.Default.expireMsg = TT_DESTROYED
			TTData.Default.expireColor = { 1.0, 1.0, 0.0 };
			TTData.Default.warningMsg = TT_WARNING
			TTData.Default.warningColor = { 0.0, 1.0, 0.0 };
			TTData.Default.warningTime = 10;
		end
		
		if( not TTData.Totems ) then
			TTData.Totems = { };
			TTData.Totems[TT_DISEASE_CLEANSING] = {};
			TTData.Totems[TT_EARTHBIND] = {};
			TTData.Totems[TT_FIRE_NOVA] = {};
			TTData.Totems[TT_FIRE_RESISTANCE] = {};
			TTData.Totems[TT_FLAMETONGUE] = {};
			TTData.Totems[TT_FROST_RESISTANCE] = {};
			TTData.Totems[TT_GRACE_OF_AIR] = {};
			TTData.Totems[TT_GROUNDING] = {};
			TTData.Totems[TT_HEALING_STREAM] = {} ;
			TTData.Totems[TT_MAGMA] = { warningTime=5 };
			TTData.Totems[TT_MANA_SPRING] = {};
			TTData.Totems[TT_MANA_TIDE] = { warningTime=-5 };
			TTData.Totems[TT_NATURE_RESISTANCE] = {};
			TTData.Totems[TT_POISON_CLEANSING] = {};
			TTData.Totems[TT_SEARING] = {};
			TTData.Totems[TT_SENTRY] = {};
			TTData.Totems[TT_STONECLAW] = {};
			TTData.Totems[TT_STONESKIN] = {};
			TTData.Totems[TT_STRENGTH_OF_EARTH] = {};
			TTData.Totems[TT_TREMOR] = {};
			TTData.Totems[TT_TRANQUIL_AIR] = {};
			TTData.Totems[TT_WINDFURY] = {};
			TTData.Totems[TT_WINDWALL] = {};
			TTData.Totems[TT_ANCIENT_MANA_SPRING] = {};
			TTData.Totems[TT_WRATH] = {};
		end

		for totem, data in pairs(TTData.Totems) do
			TTData.Totems[totem].dmg = 0;
		end

		for totem, data in pairs(TotemData) do
			data.damage = 0;
		end
		
		for num, totem in pairs(TTActiveTotems) do
			totem.active = nil;
		end

		TTState = 0;
                TotemusTimers_OnShow();
		TotemusTimers_SetOrientation();
	end

end

function TotemusTimers_SetupGlobals()
	if TotemusTimers_IsSetUp then
		return
	else
		TotemusTimers_IsSetUp = true
	end
	if( UnitClass("player") == TT_SHAMAN ) then
		TotemusTimers_UpdateButtons();
	else
		getglobal("TotemusTimersFrame"):Hide();
		TotemusTimers_Disable();
	end

end
